implementation module windowcontrols

//	Clean Object I/O library, version 1.1

import	StdBool, StdList, StdMisc, StdTuple
import	oswindow
import	commondef, controlcreate, controldefaccess, controllayout, controlresize, windowclipstate, windowdefaccess, windowdispose, wstateaccess


windowcontrolsFatalError :: String String -> .x
windowcontrolsFatalError function error
	= FatalError function "windowcontrols" error

//	Auxiliary functions:

getHMarginValue :: !(Int,Int) ![WindowAttribute .ps] -> (Int,Int)
getHMarginValue (left,right) atts = getwindowhmargin (snd (Select iswindowhmargin (WindowHMargin left right) atts))

getVMarginValue :: !(Int,Int) ![WindowAttribute .ps] -> (Int,Int)
getVMarginValue (top,bottom) atts = getwindowvmargin (snd (Select iswindowvmargin (WindowVMargin top bottom) atts))

getItemSpaceValue :: !(Int,Int) ![WindowAttribute .ps] -> (Int,Int)
getItemSpaceValue (hor,vert) atts = getwindowitemspace (snd (Select iswindowitemspace (WindowItemSpace hor vert) atts))

checkNewWindowSize :: !Size !Size !OSWindowPtr !*OSToolbox -> *OSToolbox
checkNewWindowSize curSize newSize wPtr tb
	| curSize==newSize
	= tb
	= OSsetWindowSize wPtr (toTuple newSize) tb

/*	opencontrols adds the given controls to the window. 
	It is assumed that the new controls do not conflict with the current controls.
*/
opencontrols :: .ls ![WElementHandle .ls .ps] !(WindowStateHandle .ps) !*OSToolbox -> (!WindowStateHandle .ps,!*OSToolbox)
opencontrols ls newItems wsH=:{wshIds,wshHandle=Just wlsH=:{wlsHandle=wH=:{whItems=curItems}}} tb
	# (nrCurItems,curItems)	= Ulength curItems
	  (itemNrs,newItems)	= genWElementItemNrs whItemNrs newItems
	  newItems				= [WChangeLSHandle {wChangeLS=ls,wChangeItems=newItems}]
	  allItems				= curItems++newItems
	# ((curw,curh),tb)		= OSgetWindowSize wPtr tb
	  curSize				= {w=curw,h=curh}
	# (wMetrics,tb)			= OSDefaultWindowMetrics tb
	  hMargins				= getHMarginValue   (wMetrics.osmHorMargin,   wMetrics.osmHorMargin)    whAtts
	  vMargins				= getVMarginValue   (wMetrics.osmVerMargin,   wMetrics.osmVerMargin)    whAtts
	  spaces				= getItemSpaceValue (wMetrics.osmHorItemSpace,wMetrics.osmVerItemSpace) whAtts
	  reqSize				= {w=curw-fst hMargins-snd hMargins,h=curh-fst vMargins-snd vMargins}
	# (derSize,allItems,tb)	= layoutControls wMetrics hMargins vMargins spaces reqSize zero base origin allItems tb
	  (curItems,newItems)	= Split nrCurItems allItems
	# tb					= checkNewWindowSize curSize derSize wPtr tb
	# (newItems,tb)			= createControls whDefaultId whSelect wPtr newItems tb
	  allItems				= curItems++newItems
	  wH					= {wH & whItemNrs=itemNrs,whItems=allItems}
	  wH					= invalidateWindowClipState wH
	  wsH					= {wsH & wshHandle=Just {wlsH & wlsHandle=wH}}
	= (wsH,tb)
where
	wPtr					= wshIds.wPtr
	whAtts					= wH.whAtts
	whDefaultId				= wH.whDefaultId
	whSelect				= wH.whSelect
	whItemNrs				= wH.whItemNrs
	(base,origin)			= case wH.whWindowInfo of
								Nothing			-> (zero,zero)
								Just info		-> (info.windowDomain.corner1,info.windowOrigin)
opencontrols _ _ _ _
	= windowcontrolsFatalError "opencontrols" "unexpected window placeholder argument"


/*	opencompoundcontrols adds the given controls to the compound control of the given window. 
	It is assumed that the new controls do not conflict with the current controls.
*/
opencompoundcontrols :: !Id .ls ![WElementHandle .ls .ps] !(WindowStateHandle .ps) !*OSToolbox -> (!Bool,!WindowStateHandle .ps,!*OSToolbox)
opencompoundcontrols compoundId ls newItems wsH=:{wshIds,wshHandle=Just wlsH=:{wlsHandle=wH=:{whItems}}} tb
	# (found,nrSkip,_,_,itemNrs,itemHs)	= addControlsToCompound compoundId ls newItems whItemNrs whItems
	| not found
	= (False,{wsH & wshHandle=Just {wlsH & wlsHandle={wH & whItems=itemHs}}},tb)
	# (oldItems`,itemHs,tb)				= getWElementHandles` wPtr itemHs tb
	# ((curw,curh),tb)					= OSgetWindowSize wPtr tb
	  curSize							= {w=curw,h=curh}
	# (wMetrics,tb)						= OSDefaultWindowMetrics tb
	  hMargins							= getHMarginValue   (wMetrics.osmHorMargin,   wMetrics.osmHorMargin)    whAtts
	  vMargins							= getVMarginValue   (wMetrics.osmVerMargin,   wMetrics.osmVerMargin)    whAtts
	  spaces							= getItemSpaceValue (wMetrics.osmHorItemSpace,wMetrics.osmVerItemSpace) whAtts
	  reqSize							= {w=curw-fst hMargins-snd hMargins,h=curh-fst vMargins-snd vMargins}
	# (derSize,itemHs,tb)				= layoutControls wMetrics hMargins vMargins spaces reqSize zero base origin itemHs tb
	# tb								= checkNewWindowSize curSize derSize wPtr tb
	# (itemHs,tb)						= createCompoundControls compoundId nrSkip whDefaultId whSelect wPtr itemHs tb
	# (newItems`,itemHs,tb)				= getWElementHandles` wPtr itemHs tb
	# tb								= relayoutControls wMetrics (0,0) wPtr oldItems` newItems` tb
	  wH								= {wH & whItemNrs=itemNrs,whItems=itemHs}
	  wH								= invalidateWindowClipState wH
	= (True,{wsH & wshHandle=Just {wlsH & wlsHandle=wH}},tb)
where
	wPtr								= wshIds.wPtr
	whAtts								= wH.whAtts
	whDefaultId							= wH.whDefaultId
	whSelect							= wH.whSelect
	whItemNrs							= wH.whItemNrs
	(base,origin)						= case wH.whWindowInfo of
											Nothing			-> (zero,zero)
											Just info		-> (info.windowDomain.corner1,info.windowOrigin)
	
	addControlsToCompound :: !Id .ls` ![WElementHandle .ls` .ps] [Int] ![WElementHandle .ls .ps]
				  -> (!Bool,!Int,.ls`,![WElementHandle .ls` .ps],[Int],![WElementHandle .ls .ps])
	addControlsToCompound compoundId ls newItems itemNrs itemHs
		| isEmpty itemHs
		= (False,0,ls,newItems,itemNrs,itemHs)
		# (itemH,itemHs)							= HdTl itemHs
		# (found,nrSkip,ls,newItems,itemNrs,itemH)	= addControlsToCompound` compoundId ls newItems itemNrs itemH
		| found
		= (found,nrSkip,ls,newItems,itemNrs,[itemH:itemHs])
		# (found,nrSkip,ls,newItems,itemNrs,itemHs)	= addControlsToCompound compoundId ls newItems itemNrs itemHs
		= (found,nrSkip,ls,newItems,itemNrs,[itemH:itemHs])
	where
		addControlsToCompound` :: !Id .ls` ![WElementHandle .ls` .ps] [Int] !(WElementHandle .ls .ps)
					   -> (!Bool,!Int,.ls`,![WElementHandle .ls` .ps],[Int], !WElementHandle .ls .ps)
		addControlsToCompound` compoundId ls newItems itemNrs (WListLSHandle itemHs)
			# (found,nrSkip,ls,newItems,itemNrs,itemHs)	= addControlsToCompound compoundId ls newItems itemNrs itemHs
			= (found,nrSkip,ls,newItems,itemNrs,WListLSHandle itemHs)
		addControlsToCompound` compoundId ls newItems itemNrs (WExtendLSHandle wExH=:{wExtendItems=itemHs})
			# (found,nrSkip,ls,newItems,itemNrs,itemHs)	= addControlsToCompound compoundId ls newItems itemNrs itemHs
			= (found,nrSkip,ls,newItems,itemNrs,WExtendLSHandle {wExH & wExtendItems=itemHs})
		addControlsToCompound` compoundId ls newItems itemNrs (WChangeLSHandle wChH=:{wChangeItems=itemHs})
			# (found,nrSkip,ls,newItems,itemNrs,itemHs)	= addControlsToCompound compoundId ls newItems itemNrs itemHs
			= (found,nrSkip,ls,newItems,itemNrs,WChangeLSHandle {wChH & wChangeItems=itemHs})
		addControlsToCompound` compoundId ls newItems itemNrs (WItemHandle itemH)
			# (found,nrSkip,ls,newItems,itemNrs,itemH) = addControlsToCompound`` compoundId ls newItems itemNrs itemH
			= (found,nrSkip,ls,newItems,itemNrs,WItemHandle itemH)
		where
			addControlsToCompound`` :: !Id .ls` ![WElementHandle .ls` .ps] [Int] !(WItemHandle .ls .ps)
							-> (!Bool,!Int,.ls`,![WElementHandle .ls` .ps],[Int], !WItemHandle .ls .ps)
			addControlsToCompound`` compoundId ls newItems itemNrs itemH=:{wItemKind,wItemId}
				| wItemKind<>IsCompoundControl
					= (False,0,ls,newItems,itemNrs,itemH)
				| not (identifyMaybeId compoundId wItemId)
					# (found,nrSkip,ls,newItems,itemNrs,itemHs)	= addControlsToCompound compoundId ls newItems itemNrs itemH.wItems
					  itemH										= {itemH & wItems=itemHs}
					  itemH										= if found (invalidateCompoundClipState itemH) itemH
					= (found,nrSkip,ls,newItems,itemNrs,itemH)
				// otherwise
				# (nrSkip,curItems)	= Ulength itemH.wItems
				  (itemNrs,newItems)= genWElementItemNrs itemNrs newItems
				  newItems			= [WChangeLSHandle {wChangeLS=ls,wChangeItems=newItems}]
				  itemH				= {itemH & wItems=curItems++newItems}
				  itemH				= invalidateCompoundClipState itemH
				= (True,nrSkip,undef,[],itemNrs,itemH)
opencompoundcontrols _ _ _ _ _
	= windowcontrolsFatalError "opencompoundcontrols" "unexpected window placeholder argument"


/*	closecontrols closes the indicated controls and returns their r(2)ids if appropriate.
*/
closecontrols :: ![Id] !Bool !(WindowStateHandle .ps) !*OSToolbox -> (![Id],!WindowStateHandle .ps,!*OSToolbox)
closecontrols closeIds relayout wsH=:{wshIds={wPtr},wshHandle=Just wlsH=:{wlsHandle=wH=:{whItems=curItems}}} tb
	# (freeRIds,_,itemNrs,itemHs,tb)= closeWElementHandles wPtr closeIds whItemNrs curItems tb
	| not relayout
		# wH						= {wH & whItemNrs=itemNrs,whItems=itemHs}
		  wH						= invalidateWindowClipState wH
		= (freeRIds,{wsH & wshHandle=Just {wlsH & wlsHandle=wH}},tb)
	# (oldItems`,itemHs,tb)			= getWElementHandles` wPtr itemHs tb
	# ((curw,curh),tb)				= OSgetWindowSize wPtr tb
	# (wMetrics,tb)					= OSDefaultWindowMetrics tb
	  hMargins						= getHMarginValue   (wMetrics.osmHorMargin,   wMetrics.osmHorMargin)    whAtts
	  vMargins						= getVMarginValue   (wMetrics.osmVerMargin,   wMetrics.osmVerMargin)    whAtts
	  spaces						= getItemSpaceValue (wMetrics.osmHorItemSpace,wMetrics.osmVerItemSpace) whAtts
	  reqSize						= {w=curw-fst hMargins-snd hMargins,h=curh-fst vMargins-snd vMargins}
	# (_,itemHs,tb)					= layoutControls wMetrics hMargins vMargins spaces reqSize zero base origin itemHs tb
	# (newItems`,itemHs,tb)			= getWElementHandles` wPtr itemHs tb
	# tb							= relayoutControls wMetrics (0,0) wPtr oldItems` newItems` tb
	  wH							= {wH & whItemNrs=itemNrs, whItems=itemHs}
	  wH							= invalidateWindowClipState wH
	= (freeRIds,{wsH & wshHandle=Just {wlsH & wlsHandle=wH}},tb)
where
	whItemNrs						= wH.whItemNrs
	whAtts							= wH.whAtts
	(base,origin)					= case wH.whWindowInfo of
										Nothing			-> (zero,zero)
										Just info		-> (info.windowDomain.corner1,info.windowOrigin)
	
	closeWElementHandles :: !OSWindowPtr ![Id]  [Int] ![WElementHandle .ls .ps] !*OSToolbox
							   -> (![Id],![Id],![Int],![WElementHandle .ls .ps],!*OSToolbox)
	closeWElementHandles parentPtr ids itemNrs itemHs tb
		| isEmpty ids || isEmpty itemHs
		= ([],ids,itemNrs,itemHs,tb)
		# (itemH,itemHs)						= HdTl itemHs
		  (close,rids1,ids,itemNrs,itemH, tb)	= closeWElementHandle  parentPtr ids itemNrs itemH  tb
		  (      rids2,ids,itemNrs,itemHs,tb)	= closeWElementHandles parentPtr ids itemNrs itemHs tb
		  rids									= rids1++rids2
		| close
		= (rids,ids,itemNrs,       itemHs, tb)
		= (rids,ids,itemNrs,[itemH:itemHs],tb)
	where
		closeWElementHandle :: !OSWindowPtr ![Id]  [Int] !(WElementHandle .ls .ps) !*OSToolbox
							-> (!Bool,![Id],![Id],![Int], !WElementHandle .ls .ps, !*OSToolbox)
		closeWElementHandle parentPtr ids itemNrs (WListLSHandle itemHs) tb
			# (rids,ids,itemNrs,itemHs,tb)	= closeWElementHandles parentPtr ids itemNrs itemHs tb
			= (isEmpty itemHs,rids,ids,itemNrs,WListLSHandle itemHs,tb)
		closeWElementHandle parentPtr ids itemNrs (WExtendLSHandle wExH=:{wExtendItems=itemHs}) tb
			# (rids,ids,itemNrs,itemHs,tb)	= closeWElementHandles parentPtr ids itemNrs itemHs tb
			= (isEmpty itemHs,rids,ids,itemNrs,WExtendLSHandle {wExH & wExtendItems=itemHs},tb)
		closeWElementHandle parentPtr ids itemNrs (WChangeLSHandle wChH=:{wChangeItems=itemHs}) tb
			# (rids,ids,itemNrs,itemHs,tb)	= closeWElementHandles parentPtr ids itemNrs itemHs tb
			= (isEmpty itemHs,rids,ids,itemNrs,WChangeLSHandle {wChH & wChangeItems=itemHs},tb)
		closeWElementHandle parentPtr ids itemNrs (WItemHandle itemH) tb
			# (keep,rids,ids,itemNrs,itemH,tb)	= closeWItemHandle parentPtr ids itemNrs itemH tb
			= (keep,rids,ids,itemNrs,WItemHandle itemH,tb)
		where
			closeWItemHandle :: !OSWindowPtr ![Id]  [Int] !(WItemHandle .ls .ps) !*OSToolbox
							 -> (!Bool,![Id],![Id],![Int], !WItemHandle .ls .ps, !*OSToolbox)
			closeWItemHandle parentPtr ids itemNrs itemH=:{wItemKind=IsCompoundControl} tb
				# (close,ids)					= case itemH.wItemId of
													(Just id)	-> RemoveCheck id ids
													_			-> (False,ids)
				# (rids,ids,itemNrs,itemHs,tb)	= closeWElementHandles parentPtr ids itemNrs itemH.wItems tb
				  itemH							= {itemH & wItems=itemHs}
				| not close
				= (close,rids,ids,itemNrs,invalidateCompoundClipState itemH,tb)
				# (rids1,tb)					= disposeWItemHandle itemH tb
				# tb							= OSinvalidateWindowRect parentPtr (PosSizeToRect itemH.wItemPos itemH.wItemSize) tb
				= (close,rids++rids1,ids,itemNrs,itemH,tb)
			closeWItemHandle parentPtr ids itemNrs itemH tb
				# (close,ids)	= case itemH.wItemId of
									(Just id)	-> RemoveCheck id ids
									_			-> (False,ids)
				| not close
				= (close,[],ids,itemNrs,itemH,tb)
				# (rids,tb)		= disposeWItemHandle itemH tb
				# tb			= OSinvalidateWindowRect parentPtr (PosSizeToRect itemH.wItemPos itemH.wItemSize) tb
				= (close,rids,ids,[itemH.wItemNr:itemNrs],itemH,tb)
closecontrols _ _ _ _
	= windowcontrolsFatalError "closecontrols" "unexpected window placeholder argument"


/*	setcontrolpos changes the position of the indicated control.
*/
setcontrolpos :: !Id !ItemPos !(WindowStateHandle .ps) !*OSToolbox -> (!Bool,!WindowStateHandle .ps,!*OSToolbox)
setcontrolpos id newPos wsH=:{wshIds,wshHandle=Just wlsH=:{wlsHandle=wH=:{whItems=oldItems}}} tb
	| not (validateNewItemPos id newPos oldItems)
	= (False,wsH,tb)
	# ((curw,curh),tb)			= OSgetWindowSize wPtr tb
	# (wMetrics,tb)				= OSDefaultWindowMetrics tb
	  hMargins					= getHMarginValue   (wMetrics.osmHorMargin,   wMetrics.osmHorMargin)    whAtts
	  vMargins					= getVMarginValue   (wMetrics.osmVerMargin,   wMetrics.osmVerMargin)    whAtts
	  spaces					= getItemSpaceValue (wMetrics.osmHorItemSpace,wMetrics.osmVerItemSpace) whAtts
	  reqSize					= {w=curw-fst hMargins-snd hMargins,h=curh-fst vMargins-snd vMargins}
	# (oldItems`,oldItems,tb)	= getWElementHandles` wPtr oldItems tb
	  (_,newItems)				= setNewItemPos id newPos oldItems
	# (_,newItems,tb)			= layoutControls wMetrics hMargins vMargins spaces reqSize zero base origin newItems tb
	# (newItems`,newItems,tb)	= getWElementHandles` wPtr newItems tb
	  wH						= {wH & whItems=newItems}
	  wH						= invalidateWindowClipState wH
	  wsH						= {wsH & wshHandle=Just {wlsH & wlsHandle=wH}}
	# tb						= relayoutControls wMetrics (0,0) wPtr oldItems` newItems` tb
	= (True,wsH,tb)
where
	wPtr						= wshIds.wPtr
	whAtts						= wH.whAtts
	(base,origin)				= case wH.whWindowInfo of
									Nothing			-> (zero,zero)
									Just info		-> (info.windowDomain.corner1,info.windowOrigin)
	
	validateNewItemPos :: !Id !ItemPos ![WElementHandle .ls .ps] -> Bool
	validateNewItemPos controlId itemPos=:(itemLoc,_) itemHs
		= isEmpty (controlsExist ids itemHs)
	where
		ids	= case itemLoc of
				LeftOf	id	-> [id,controlId]
				RightTo	id	-> [id,controlId]
				Above	id	-> [id,controlId]
				Below	id	-> [id,controlId]
				_			-> [controlId]
		
		controlsExist :: ![Id] ![WElementHandle .ls .ps] -> [Id]
		controlsExist ids itemHs
			| isEmpty ids || isEmpty itemHs
			= ids
			# (itemH,itemHs)	= HdTl itemHs
			= controlsExist (controlsExist` ids itemH) itemHs
		where
			controlsExist` :: ![Id] !(WElementHandle .ls .ps) -> [Id]
			controlsExist` ids (WListLSHandle itemHs)					= controlsExist ids itemHs
			controlsExist` ids (WExtendLSHandle {wExtendItems=itemHs})	= controlsExist ids itemHs
			controlsExist` ids (WChangeLSHandle {wChangeItems=itemHs})	= controlsExist ids itemHs
			controlsExist` ids (WItemHandle {wItemId,wItems})			= controlsExist (if (isJust wItemId) (removeMember (fromJust wItemId) ids) ids) wItems
	
	setNewItemPos :: !Id !ItemPos ![WElementHandle .ls .ps] -> (!Bool,![WElementHandle .ls .ps])
	setNewItemPos controlId itemPos itemHs
		| isEmpty itemHs
		= (False,itemHs)
		# (itemH,itemHs)= HdTl itemHs
		  (done,itemH)	= setNewItemPos` controlId itemPos itemH
		| done
		= (done,[itemH:itemHs])
		# (done,itemHs)	= setNewItemPos  controlId itemPos itemHs
		= (done,[itemH:itemHs])
	where
		setNewItemPos` :: !Id !ItemPos !(WElementHandle .ls .ps) -> (!Bool,!WElementHandle .ls .ps)
		setNewItemPos` controlId itemPos (WListLSHandle itemHs)
			# (done,itemHs)	= setNewItemPos controlId itemPos itemHs
			= (done,WListLSHandle itemHs)
		setNewItemPos` controlId itemPos (WExtendLSHandle wExH=:{wExtendItems=itemHs})
			# (done,itemHs)	= setNewItemPos controlId itemPos itemHs
			= (done,WExtendLSHandle {wExH & wExtendItems=itemHs})
		setNewItemPos` controlId itemPos (WChangeLSHandle wChH=:{wChangeItems=itemHs})
			# (done,itemHs)	= setNewItemPos controlId itemPos itemHs
			= (done,WChangeLSHandle {wChH & wChangeItems=itemHs})
		setNewItemPos` controlId itemPos (WItemHandle itemH)
			# (done,itemH)	= setNewItemPos`` controlId itemPos itemH
			= (done,WItemHandle itemH)
		where
			setNewItemPos`` :: !Id !ItemPos !(WItemHandle .ls .ps) -> (!Bool,!WItemHandle .ls .ps)
			setNewItemPos`` controlId itemPos itemH=:{wItemId,wItemKind}
				| isJust wItemId && controlId==fromJust wItemId
				= (True,{itemH & wItemAtts=snd (Replace iscontrolpos (ControlPos itemPos) itemH.wItemAtts)})
				| wItemKind<>IsCompoundControl
				= (False,itemH)
				# (done,itemHs)	= setNewItemPos controlId itemPos itemH.wItems
				  itemH			= {itemH & wItems=itemHs}
				  itemH			= if done (invalidateCompoundClipState itemH) itemH
				= (done,itemH)
setcontrolpos _ _ _ _
	= windowcontrolsFatalError "setcontrolpos" "unexpected window placeholder argument"
